<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddInventoryTransferIdToInventoryReceivesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('inventory_receives', function (Blueprint $table) {
             if (!Schema::hasColumn('inventory_receives','inventory_transfer_id')){
                $table->integer('inventory_transfer_id')->unsigned()->nullable();
                $table->integer('driver_id')->unsigned()->nullable();
                $table->string('transit_number')->nullable();
                $table->string('tanker_number')->nullable();
                $table->string('destination')->nullable();
                $table->string('loading_date')->nullable();
			}
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('inventory_receives', function (Blueprint $table) {
            //
        });
    }
}
