<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLangTranslatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
            if(!Schema::hasTable('lang_translates')) {
                Schema::create('lang_translates', function (Blueprint $table) {
                    $table->bigIncrements('id');
                    $table->string('word_key')->nullable();
                    $table->string('word_translate')->nullable();
                    $table->string('file_path')->nullable();
                    $table->string('folder')->nullable();
                    $table->string('file_name')->nullable();
                    $table->timestamps();
                });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('lang_translates');
    }
}
