<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddExpenseTransactionIdToItemExpenseDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('item_expense_details', function (Blueprint $table) {
            if (!Schema::hasColumn('item_expense_details','expense_transaction_id')){
                $table->integer('expense_transaction_id')->unsigned()->nullable();
				$table->datetime('last_expire_date')->nullable();
				$table->double('quantity', 10)->nullable();
				$table->string('price_type')->nullable();
			}
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('item_expense_details', function (Blueprint $table) {
            //
        });
    }
}
