<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransportCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('transport_companies')) {
            Schema::create('transport_companies', function (Blueprint $table) {
                $table->bigIncrements('id');

                $table->integer('company_id')->unsigned()->nullable();
                $table->integer('branch')->unsigned()->nullable();
                $table->integer('number')->unsigned()->nullable();
                
                $table->string('name');
                $table->string('email')->nullable();
                $table->string('phone')->nullable();
                $table->string('photo')->nullable();


                $table->datetime('expire_date')->nullable();
                $table->datetime('reg_date')->nullable();
                $table->string('license_type')->nullable();
                $table->string('license_number')->nullable();


                $table->string('address')->nullable();
                $table->char('city',50)->nullable();
                $table->char('country',50)->nullable();
                $table->char('post_code',50)->nullable();

                $table->text('description')->nullable();


                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transport_companies');
    }
}
