<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBranchTransferDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('branch_transfer_details')) {
            Schema::create('branch_transfer_details', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('branch_transfer_id')->unsigned();
                $table->integer('asset_transaction')->unsigned();
                $table->integer('inventory_id')->unsigned();
                $table->integer('site_id')->unsigned()->nullable();
              
                $table->double('quantity');
                $table->double('cost');
                $table->integer('um_id')->unsigned();
                $table->integer('inventory_category_id')->unsigned()->nullable();
                $table->double('other_measure')->nullable();
                $table->double('other_measure2')->nullable();
                $table->timestamps();



            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('branch_transfer_details');
    }
}
