<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBranchTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('branch_transfers')) {
            Schema::create('branch_transfers', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('ref_no')->nullable();
                $table->boolean('is_transfered')->nullable()->default(0);
                $table->boolean('is_received')->nullable()->default(0);
                $table->datetime('date');
                $table->string('description')->nullable();
                $table->string('type')->nullable();
                $table->unsignedInteger('from_member_id');
                $table->unsignedInteger('to_member_id');
                $table->unsignedInteger('company_id')->nullable();
                $table->unsignedInteger('from_company_id');
                $table->unsignedInteger('to_company_id');
                $table->unsignedInteger('payable_transaction_id')->nullable();
                $table->unsignedInteger('receivable_transaction_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('branch_transfers');
    }
}
