<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdjustmentTransactionDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('adjustment_transaction_details')) {
            Schema::create('adjustment_transaction_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('transaction_id')->unsigned()->comment('if the adjustments cost effects member store transaction_id here');
                $table->integer('member_id')->unsigned();
                $table->string('type');
                $table->integer('type_id')->unsigned()->nullable();
                $table->integer('adjustment_id')->unsigned();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('adjustment_transaction_details');
    }
}
