<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmployeePayrollTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('employee_payroll_taxes')) {
            Schema::create('employee_payroll_taxes', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('payroll_id')->unsigned();
                $table->string('tax_currency');
                $table->double('tax_rate');
                $table->integer('expense_transaction_id')->unsigned();
                $table->integer('transaction_id')->unsigned();
                $table->integer('payroll_tax_detail_id')->unsigned()->nullable();


                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_payroll_taxes');
    }
}
