<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayrollTaxDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('payroll_tax_details')) {
            Schema::create('payroll_tax_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->double('from_amount');
                $table->double('to_amount');
                $table->double('tax_percentage')->nullable();
                $table->double('extra_amount')->nullable();
                $table->integer('payroll_tax_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_tax_details');
    }
}
