<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayrollTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('payroll_taxes')) {
            Schema::create('payroll_taxes', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('title');
                $table->string('currency');
                $table->string('description')->nullable();
                $table->integer('company_id')->unsigned()->nullable();

                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_tax');
    }
}
