<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAttendancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

       if(!Schema::hasTable('attendances')) {
            Schema::create('attendances', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('start')->unsigned()->nullable();
                $table->integer('end')->unsigned()->nullable();
                $table->datetime('date')->nullable();
                $table->integer('number')->nullable()->nullable();
                $table->text('description')->nullable();
                $table->double('static_shift')->nullable();
                $table->double('static_hour')->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('attendances');
    }
}
