<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAttendanceSheetsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('attendance_sheets')) {
            Schema::create('attendance_sheets', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('employee_id')->unsigned();
                $table->integer('attendance_id')->unsigned();
                $table->datetime('date')->nullable();
                $table->integer('present_adsent')->nullable();
                $table->string('leave_type')->nullable();
                $table->string('attendance_type')->nullable();
                $table->string('attendance_type2')->nullable();
                $table->text('description')->nullable();
                $table->integer('leave_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->integer('user_id')->unsigned();
                $table->double('static_time')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('attendance_sheets');
    }
}
