<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCompanyInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('company_infos')) {
            Schema::create('company_infos', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('company_id')->unsigned();
                $table->string('lang');
                $table->string('voucher_name')->nullable();
                $table->string('type')->nullable();
                $table->string('name')->nullable();

                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('company_infos');
    }
}
