<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddItemExpenseCategoryIdToItemExpenseDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('item_expense_details', function (Blueprint $table) {
            if (!Schema::hasColumn('item_expense_details', 'item_expense_category_id') && !Schema::hasColumn('item_expense_details', 'amount')) {
                $table->integer('item_expense_category_id')->unsigned()->nullable();
                $table->double('amount')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('item_expense_details', function (Blueprint $table) {
            //
        });
    }
}
