<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCompanyIdToAllOtherTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /*
         * newly added
         */

        Schema::table('payroll_forms', function (Blueprint $table) {
            if (!Schema::hasColumn('payroll_forms', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to accounts
        Schema::table('accounts', function (Blueprint $table) {
            if (!Schema::hasColumn('accounts', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to adjustments
        Schema::table('adjustments', function (Blueprint $table) {
            if (!Schema::hasColumn('adjustments', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('adjustment_details', function (Blueprint $table) {
            if (!Schema::hasColumn('adjustment_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('adjustment_stock_outs', function (Blueprint $table) {
            if (!Schema::hasColumn('adjustment_stock_outs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to advance pricings
        Schema::table('advance_pricings', function (Blueprint $table) {
            if (!Schema::hasColumn('advance_pricings', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('advance_pricing_details', function (Blueprint $table) {
            if (!Schema::hasColumn('advance_pricing_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('amount_formats', function (Blueprint $table) {
            if (!Schema::hasColumn('amount_formats', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to assemblies
        Schema::table('assemblies', function (Blueprint $table) {
            if (!Schema::hasColumn('assemblies', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('assembly_expenses', function (Blueprint $table) {
            if (!Schema::hasColumn('assembly_expenses', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to attachments
        Schema::table('attachments', function (Blueprint $table) {
            if (!Schema::hasColumn('attachments', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to audits
        Schema::table('audits', function (Blueprint $table) {
            if (!Schema::hasColumn('audits', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to builds
    


        Schema::table('bank_checks', function (Blueprint $table) {
            if (!Schema::hasColumn('bank_checks', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('builds', function (Blueprint $table) {
            if (!Schema::hasColumn('builds', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('build_details', function (Blueprint $table) {
            if (!Schema::hasColumn('build_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('build_expenses', function (Blueprint $table) {
            if (!Schema::hasColumn('build_expenses', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('build_infos', function (Blueprint $table) {
            if (!Schema::hasColumn('build_infos', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('build_stock_ins', function (Blueprint $table) {
            if (!Schema::hasColumn('build_stock_ins', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('build_stock_outs', function (Blueprint $table) {
            if (!Schema::hasColumn('build_stock_outs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to contracts
        Schema::table('contracts', function (Blueprint $table) {
            if (!Schema::hasColumn('contracts', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to contracts
        Schema::table('contract_details', function (Blueprint $table) {
            if (!Schema::hasColumn('contract_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('contract_expense_purchases', function (Blueprint $table) {
            if (!Schema::hasColumn('contract_expense_purchases', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('contract_purchases', function (Blueprint $table) {
            if (!Schema::hasColumn('contract_purchases', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to contract stocks
        Schema::table('contract_stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('contract_stocks', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('contract_shareholders', function (Blueprint $table) {
            if (!Schema::hasColumn('contract_shareholders', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to costs
        Schema::table('costs', function (Blueprint $table) {
            if (!Schema::hasColumn('costs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to cost for customers
        Schema::table('cost_for_customers', function (Blueprint $table) {
            if (!Schema::hasColumn('cost_for_customers', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to custome reports
        Schema::table('custome_reports', function (Blueprint $table) {
            if (!Schema::hasColumn('custome_reports', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('daily_expenses', function (Blueprint $table) {
            if (!Schema::hasColumn('daily_expenses', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to daily expenses
        Schema::table('deliveries', function (Blueprint $table) {
            if (!Schema::hasColumn('deliveries', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('delivery_details', function (Blueprint $table) {
            if (!Schema::hasColumn('delivery_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('delivery_stock_outs', function (Blueprint $table) {
            if (!Schema::hasColumn('delivery_stock_outs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('delivery_stock_outs', function (Blueprint $table) {
            if (!Schema::hasColumn('delivery_stock_outs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to drawings
        Schema::table('drawings', function (Blueprint $table) {
            if (!Schema::hasColumn('drawings', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to drivers
        Schema::table('drivers', function (Blueprint $table) {
            if (!Schema::hasColumn('drivers', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to expenses
        Schema::table('expenses', function (Blueprint $table) {
            if (!Schema::hasColumn('expenses', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('expense_details', function (Blueprint $table) {
            if (!Schema::hasColumn('expense_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });
        // add company_id to daily expenses
        Schema::table('daily_expenses', function (Blueprint $table) {
            if (!Schema::hasColumn('daily_expenses', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to deliveries
        Schema::table('deliveries', function (Blueprint $table) {
            if (!Schema::hasColumn('deliveries', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to expense categories
        Schema::table('expense_categories', function (Blueprint $table) {
            if (!Schema::hasColumn('expense_categories', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to factor designs
        Schema::table('factor_designs', function (Blueprint $table) {
            if (!Schema::hasColumn('factor_designs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('fined_drivers', function (Blueprint $table) {
            if (!Schema::hasColumn('fined_drivers', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to formulas
        Schema::table('formulas', function (Blueprint $table) {
            if (!Schema::hasColumn('formulas', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to gifts
        Schema::table('gifts', function (Blueprint $table) {
            if (!Schema::hasColumn('gifts', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to general infos
        Schema::table('general_infos', function (Blueprint $table) {
            if (!Schema::hasColumn('general_infos', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to glasses
        Schema::table('glasses', function (Blueprint $table) {
            if (!Schema::hasColumn('glasses', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to information_to_updates
        Schema::table('information_to_updates', function (Blueprint $table) {
            if (!Schema::hasColumn('information_to_updates', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to inventories
        Schema::table('inventories', function (Blueprint $table) {
            if (!Schema::hasColumn('inventories', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to inventory categories
        Schema::table('inventory_categories', function (Blueprint $table) {
            if (!Schema::hasColumn('inventory_categories', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to inventory_receives
        Schema::table('inventory_receives', function (Blueprint $table) {
            if (!Schema::hasColumn('inventory_receives', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to inventory_sites
        Schema::table('inventory_sites', function (Blueprint $table) {
            if (!Schema::hasColumn('inventory_sites', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to inventory_transfers
        Schema::table('inventory_transfers', function (Blueprint $table) {
            if (!Schema::hasColumn('inventory_transfers', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('inventory_transfer_details', function (Blueprint $table) {
            if (!Schema::hasColumn('inventory_transfer_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('inventory_transfer_infos', function (Blueprint $table) {
            if (!Schema::hasColumn('inventory_transfer_infos', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to items
        Schema::table('items', function (Blueprint $table) {
            if (!Schema::hasColumn('items', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to item expenses
        Schema::table('item_expenses', function (Blueprint $table) {
            if (!Schema::hasColumn('item_expenses', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('item_expense_details', function (Blueprint $table) {
            if (!Schema::hasColumn('item_expense_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('item_expense_outs', function (Blueprint $table) {
            if (!Schema::hasColumn('item_expense_outs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to item expense categories
        Schema::table('item_expense_categories', function (Blueprint $table) {
            if (!Schema::hasColumn('item_expense_categories', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to job_titles
        Schema::table('job_titles', function (Blueprint $table) {
            if (!Schema::hasColumn('job_titles', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to journal_entries
        Schema::table('journal_entries', function (Blueprint $table) {
            if (!Schema::hasColumn('journal_entries', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('journal_entry_details', function (Blueprint $table) {
            if (!Schema::hasColumn('journal_entry_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to lives
        Schema::table('lives', function (Blueprint $table) {
            if (!Schema::hasColumn('lives', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to loans
        Schema::table('loans', function (Blueprint $table) {
            if (!Schema::hasColumn('loans', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to machines
        Schema::table('machines', function (Blueprint $table) {
            if (!Schema::hasColumn('machines', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to main_stocks
        Schema::table('main_stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('main_stocks', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to measure exchanges
        Schema::table('measure_exchanges', function (Blueprint $table) {
            if (!Schema::hasColumn('measure_exchanges', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to measure exchanges
        Schema::table('measure_units', function (Blueprint $table) {
            if (!Schema::hasColumn('measure_units', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to members
        Schema::table('members', function (Blueprint $table) {
            if (!Schema::hasColumn('members', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('member_informations', function (Blueprint $table) {
            if (!Schema::hasColumn('member_informations', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('member_opening_balances', function (Blueprint $table) {
            if (!Schema::hasColumn('member_opening_balances', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('member_payable_levels', function (Blueprint $table) {
            if (!Schema::hasColumn('member_payable_levels', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('member_job_titles', function (Blueprint $table) {
            if (!Schema::hasColumn('member_job_titles', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('member_journals', function (Blueprint $table) {
            if (!Schema::hasColumn('member_journals', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to members
        Schema::table('member_classes', function (Blueprint $table) {
            if (!Schema::hasColumn('member_classes', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to member transfers
        Schema::table('member_transfers', function (Blueprint $table) {
            if (!Schema::hasColumn('member_transfers', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id tomember_typs
      /*  Schema::table('member_typs', function (Blueprint $table) {
            if (!Schema::hasColumn('member_typs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });*/


        // add company_id to menus
        Schema::table('menus', function (Blueprint $table) {
            if (!Schema::hasColumn('menus', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('menu_columns', function (Blueprint $table) {
            if (!Schema::hasColumn('menu_columns', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('m_stocks_in', function (Blueprint $table) {
            if (!Schema::hasColumn('m_stocks_in', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('m_stocks_out', function (Blueprint $table) {
            if (!Schema::hasColumn('m_stocks_out', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to notes
        Schema::table('notes', function (Blueprint $table) {
            if (!Schema::hasColumn('notes', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('note_details', function (Blueprint $table) {
            if (!Schema::hasColumn('note_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to opening inventories
        Schema::table('opening_inventories', function (Blueprint $table) {
            if (!Schema::hasColumn('opening_inventories', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to opening stocks
        Schema::table('opening_stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('opening_stocks', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to opening stocks
        Schema::table('opening_stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('opening_stocks', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('other_builds', function (Blueprint $table) {
            if (!Schema::hasColumn('other_builds', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to packages
        Schema::table('packages', function (Blueprint $table) {
            if (!Schema::hasColumn('packages', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('package_details', function (Blueprint $table) {
            if (!Schema::hasColumn('package_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to payments
        Schema::table('payments', function (Blueprint $table) {
            if (!Schema::hasColumn('payments', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to payrolls
        Schema::table('payrolls', function (Blueprint $table) {
            if (!Schema::hasColumn('payrolls', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to products
        Schema::table('products', function (Blueprint $table) {
            if (!Schema::hasColumn('products', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to projects
        Schema::table('projects', function (Blueprint $table) {
            if (!Schema::hasColumn('projects', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to project build items
        Schema::table('project_build_items', function (Blueprint $table) {
            if (!Schema::hasColumn('project_build_items', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('project_builds', function (Blueprint $table) {
            if (!Schema::hasColumn('project_builds', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('project_details', function (Blueprint $table) {
            if (!Schema::hasColumn('project_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('project_expenses', function (Blueprint $table) {
            if (!Schema::hasColumn('project_expenses', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('project_expense_details', function (Blueprint $table) {
            if (!Schema::hasColumn('project_expense_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('project_finishes', function (Blueprint $table) {
            if (!Schema::hasColumn('project_finishes', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('project_items', function (Blueprint $table) {
            if (!Schema::hasColumn('project_items', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to project categories
        Schema::table('project_categories', function (Blueprint $table) {
            if (!Schema::hasColumn('project_categories', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to project item transactions
        Schema::table('project_item_transactions', function (Blueprint $table) {
            if (!Schema::hasColumn('project_item_transactions', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to project progresses
        Schema::table('project_progresses', function (Blueprint $table) {
            if (!Schema::hasColumn('project_progresses', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('project_services', function (Blueprint $table) {
            if (!Schema::hasColumn('project_services', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('project_stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('project_stocks', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('project_stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('project_stocks', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('project_stock_outs', function (Blueprint $table) {
            if (!Schema::hasColumn('project_stock_outs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('project_transactions', function (Blueprint $table) {
            if (!Schema::hasColumn('project_transactions', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('project_wastages', function (Blueprint $table) {
            if (!Schema::hasColumn('project_wastages', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to purchases
        Schema::table('purchases', function (Blueprint $table) {
            if (!Schema::hasColumn('purchases', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('purchase_discounts', function (Blueprint $table) {
            if (!Schema::hasColumn('purchase_discounts', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('purchase_infos', function (Blueprint $table) {
            if (!Schema::hasColumn('purchase_infos', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('purchase_orders', function (Blueprint $table) {
            if (!Schema::hasColumn('purchase_orders', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('purchase_order_details', function (Blueprint $table) {
            if (!Schema::hasColumn('purchase_order_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('purchase_order_records', function (Blueprint $table) {
            if (!Schema::hasColumn('purchase_order_records', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to purchase orders
        Schema::table('purchase_orders', function (Blueprint $table) {
            if (!Schema::hasColumn('purchase_orders', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('quantities', function (Blueprint $table) {
            if (!Schema::hasColumn('quantities', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('receivable_payments', function (Blueprint $table) {
            if (!Schema::hasColumn('receivable_payments', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('recipe_details', function (Blueprint $table) {
            if (!Schema::hasColumn('recipe_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('recipe_operators', function (Blueprint $table) {
            if (!Schema::hasColumn('recipe_operators', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to recipes
        Schema::table('recipes', function (Blueprint $table) {
            if (!Schema::hasColumn('recipes', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to refunds
        Schema::table('refunds', function (Blueprint $table) {
            if (!Schema::hasColumn('refunds', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('refund_stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('refund_stocks', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to refund return payments
        Schema::table('refund_return_payments', function (Blueprint $table) {
            if (!Schema::hasColumn('refund_return_payments', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('return_refund_details', function (Blueprint $table) {
            if (!Schema::hasColumn('return_refund_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to refund return transactions
        Schema::table('refund_return_transactions', function (Blueprint $table) {
            if (!Schema::hasColumn('refund_return_transactions', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('return_stock_outs', function (Blueprint $table) {
            if (!Schema::hasColumn('return_stock_outs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to refund return transactions
        Schema::table('rents', function (Blueprint $table) {
            if (!Schema::hasColumn('rents', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to refund return transactions
        Schema::table('return_backs', function (Blueprint $table) {
            if (!Schema::hasColumn('return_backs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to refund return transactions
        Schema::table('salary_details', function (Blueprint $table) {
            if (!Schema::hasColumn('salary_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to refund return transactions
        Schema::table('sales', function (Blueprint $table) {
            if (!Schema::hasColumn('sales', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to sales orders
        Schema::table('sales_orders', function (Blueprint $table) {
            if (!Schema::hasColumn('sales_orders', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('sales_order_details', function (Blueprint $table) {
            if (!Schema::hasColumn('sales_order_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('sales_order_records', function (Blueprint $table) {
            if (!Schema::hasColumn('sales_order_records', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('sale_infos', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_infos', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to sale areas
        Schema::table('sale_areas', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_areas', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to sale items
        Schema::table('sale_items', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_items', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('sale_order_receives', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_order_receives', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('sale_order_services', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_order_services', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('sale_receives', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_receives', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('sale_services', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_services', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('sale_transactions', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_transactions', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to sale items
        Schema::table('send_moneys', function (Blueprint $table) {
            if (!Schema::hasColumn('send_moneys', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to service classes
        Schema::table('service_classes', function (Blueprint $table) {
            if (!Schema::hasColumn('service_classes', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to stocks
        Schema::table('stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('stocks', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });




        Schema::table('stock_outs', function (Blueprint $table) {
            if (!Schema::hasColumn('stock_outs', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('system_alerts', function (Blueprint $table) {
            if (!Schema::hasColumn('system_alerts', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('s_products', function (Blueprint $table) {
            if (!Schema::hasColumn('s_products', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        Schema::table('s_products', function (Blueprint $table) {
            if (!Schema::hasColumn('s_products', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to temp_items
        Schema::table('temp_items', function (Blueprint $table) {
            if (!Schema::hasColumn('temp_items', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to stucks
        Schema::table('transactions', function (Blueprint $table) {
            if (!Schema::hasColumn('transactions', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to stucks
        Schema::table('transfers', function (Blueprint $table) {
            if (!Schema::hasColumn('transfers', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to stucks
        Schema::table('transfer_accounts', function (Blueprint $table) {
            if (!Schema::hasColumn('transfer_accounts', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to stucks
        Schema::table('transfer_and_loadings', function (Blueprint $table) {
            if (!Schema::hasColumn('transfer_and_loadings', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to stucks
        Schema::table('transfer_details', function (Blueprint $table) {
            if (!Schema::hasColumn('transfer_details', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('transports', function (Blueprint $table) {
            if (!Schema::hasColumn('transports', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });

        // add company_id to stucks
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        // add company_id to work types
        Schema::table('work_types', function (Blueprint $table) {
            if (!Schema::hasColumn('work_types', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

        // add company_id to accounts
        Schema::table('accounts', function (Blueprint $table) {
            if (Schema::hasColumn('accounts', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to adjustments
        Schema::table('adjustments', function (Blueprint $table) {
            if (Schema::hasColumn('adjustments', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('adjustment_details', function (Blueprint $table) {
            if (Schema::hasColumn('adjustment_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('adjustment_stock_outs', function (Blueprint $table) {
            if (Schema::hasColumn('adjustment_stock_outs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to advance pricings
        Schema::table('advance_pricings', function (Blueprint $table) {
            if (Schema::hasColumn('advance_pricings', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('advance_pricing_details', function (Blueprint $table) {
            if (Schema::hasColumn('advance_pricing_details', 'company_id')) {
                 $table->dropColumn('company_id');
            }
        });


        Schema::table('amount_formats', function (Blueprint $table) {
            if (Schema::hasColumn('amount_formats', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to assemblies
        Schema::table('assemblies', function (Blueprint $table) {
            if (Schema::hasColumn('assemblies', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('assembly_expenses', function (Blueprint $table) {
            if (Schema::hasColumn('assembly_expenses', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to attachments
        Schema::table('attachments', function (Blueprint $table) {
            if (Schema::hasColumn('attachments', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to audits
        Schema::table('audits', function (Blueprint $table) {
            if (Schema::hasColumn('audits', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to builds
  

        Schema::table('bank_checks', function (Blueprint $table) {
            if (Schema::hasColumn('bank_checks', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('builds', function (Blueprint $table) {
            if (Schema::hasColumn('builds', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('build_details', function (Blueprint $table) {
            if (Schema::hasColumn('build_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('build_expenses', function (Blueprint $table) {
            if (Schema::hasColumn('build_expenses', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('build_infos', function (Blueprint $table) {
            if (Schema::hasColumn('build_infos', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('build_stock_ins', function (Blueprint $table) {
            if (Schema::hasColumn('build_stock_ins', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('build_stock_outs', function (Blueprint $table) {
            if (Schema::hasColumn('build_stock_outs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to contracts
        Schema::table('contracts', function (Blueprint $table) {
            if (Schema::hasColumn('contracts', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to contracts
        Schema::table('contract_details', function (Blueprint $table) {
            if (Schema::hasColumn('contract_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('contract_expense_purchases', function (Blueprint $table) {
            if (Schema::hasColumn('contract_expense_purchases', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('contract_purchases', function (Blueprint $table) {
            if (Schema::hasColumn('contract_purchases', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to contract stocks
        Schema::table('contract_stocks', function (Blueprint $table) {
            if (Schema::hasColumn('contract_stocks', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('contract_shareholders', function (Blueprint $table) {
            if (Schema::hasColumn('contract_shareholders', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to costs
        Schema::table('costs', function (Blueprint $table) {
            if (Schema::hasColumn('costs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to cost for customers
        Schema::table('cost_for_customers', function (Blueprint $table) {
            if (Schema::hasColumn('cost_for_customers', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to custome reports
        Schema::table('custome_reports', function (Blueprint $table) {
            if (Schema::hasColumn('custome_reports', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('daily_expenses', function (Blueprint $table) {
            if (Schema::hasColumn('daily_expenses', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to daily expenses
        Schema::table('deliveries', function (Blueprint $table) {
            if (Schema::hasColumn('deliveries', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('delivery_details', function (Blueprint $table) {
            if (Schema::hasColumn('delivery_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('delivery_stock_outs', function (Blueprint $table) {
            if (Schema::hasColumn('delivery_stock_outs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('delivery_stock_outs', function (Blueprint $table) {
            if (Schema::hasColumn('delivery_stock_outs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to drawings
        Schema::table('drawings', function (Blueprint $table) {
            if (Schema::hasColumn('drawings', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to drivers
        Schema::table('drivers', function (Blueprint $table) {
            if (Schema::hasColumn('drivers', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to expenses
        Schema::table('expenses', function (Blueprint $table) {
            if (Schema::hasColumn('expenses', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('expense_details', function (Blueprint $table) {
            if (Schema::hasColumn('expense_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });
        // add company_id to daily expenses
        Schema::table('daily_expenses', function (Blueprint $table) {
            if (Schema::hasColumn('daily_expenses', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to deliveries
        Schema::table('deliveries', function (Blueprint $table) {
            if (Schema::hasColumn('deliveries', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to expense categories
        Schema::table('expense_categories', function (Blueprint $table) {
            if (Schema::hasColumn('expense_categories', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to factor designs
        Schema::table('factor_designs', function (Blueprint $table) {
            if (Schema::hasColumn('factor_designs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('fined_drivers', function (Blueprint $table) {
            if (Schema::hasColumn('fined_drivers', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to formulas
        Schema::table('formulas', function (Blueprint $table) {
            if (Schema::hasColumn('formulas', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to gifts
        Schema::table('gifts', function (Blueprint $table) {
            if (Schema::hasColumn('gifts', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to general infos
        Schema::table('general_infos', function (Blueprint $table) {
            if (Schema::hasColumn('general_infos', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to glasses
        Schema::table('glasses', function (Blueprint $table) {
            if (Schema::hasColumn('glasses', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to information_to_updates
        Schema::table('information_to_updates', function (Blueprint $table) {
            if (Schema::hasColumn('information_to_updates', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to inventories
        Schema::table('inventories', function (Blueprint $table) {
            if (Schema::hasColumn('inventories', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to inventory categories
        Schema::table('inventory_categories', function (Blueprint $table) {
            if (Schema::hasColumn('inventory_categories', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to inventory_receives
        Schema::table('inventory_receives', function (Blueprint $table) {
            if (Schema::hasColumn('inventory_receives', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to inventory_sites
        Schema::table('inventory_sites', function (Blueprint $table) {
            if (Schema::hasColumn('inventory_sites', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to inventory_transfers
        Schema::table('inventory_transfers', function (Blueprint $table) {
            if (Schema::hasColumn('inventory_transfers', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('inventory_transfer_details', function (Blueprint $table) {
            if (Schema::hasColumn('inventory_transfer_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('inventory_transfer_infos', function (Blueprint $table) {
            if (Schema::hasColumn('inventory_transfer_infos', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to items
        Schema::table('items', function (Blueprint $table) {
            if (Schema::hasColumn('items', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to item expenses
        Schema::table('item_expenses', function (Blueprint $table) {
            if (Schema::hasColumn('item_expenses', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('item_expense_details', function (Blueprint $table) {
            if (Schema::hasColumn('item_expense_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('item_expense_outs', function (Blueprint $table) {
            if (Schema::hasColumn('item_expense_outs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to item expense categories
        Schema::table('item_expense_categories', function (Blueprint $table) {
            if (Schema::hasColumn('item_expense_categories', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to job_titles
        Schema::table('job_titles', function (Blueprint $table) {
            if (Schema::hasColumn('job_titles', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to journal_entries
        Schema::table('journal_entries', function (Blueprint $table) {
            if (Schema::hasColumn('journal_entries', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('journal_entry_details', function (Blueprint $table) {
            if (Schema::hasColumn('journal_entry_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to lives
        Schema::table('lives', function (Blueprint $table) {
            if (Schema::hasColumn('lives', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to loans
        Schema::table('loans', function (Blueprint $table) {
            if (Schema::hasColumn('loans', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to machines
        Schema::table('machines', function (Blueprint $table) {
            if (Schema::hasColumn('machines', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to main_stocks
        Schema::table('main_stocks', function (Blueprint $table) {
            if (Schema::hasColumn('main_stocks', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to measure exchanges
        Schema::table('measure_exchanges', function (Blueprint $table) {
            if (Schema::hasColumn('measure_exchanges', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to measure exchanges
        Schema::table('measure_units', function (Blueprint $table) {
            if (Schema::hasColumn('measure_units', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to members
        Schema::table('members', function (Blueprint $table) {
            if (Schema::hasColumn('members', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('member_informations', function (Blueprint $table) {
            if (!Schema::hasColumn('member_informations', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('member_opening_balances', function (Blueprint $table) {
            if (Schema::hasColumn('member_opening_balances', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('member_payable_levels', function (Blueprint $table) {
            if (Schema::hasColumn('member_payable_levels', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('member_job_titles', function (Blueprint $table) {
            if (Schema::hasColumn('member_job_titles', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('member_journals', function (Blueprint $table) {
            if (Schema::hasColumn('member_journals', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to members
        Schema::table('member_classes', function (Blueprint $table) {
            if (Schema::hasColumn('member_classes', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to member transfers
        Schema::table('member_transfers', function (Blueprint $table) {
            if (Schema::hasColumn('member_transfers', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id tomember_typs
      /*  Schema::table('member_typs', function (Blueprint $table) {
            if (Schema::hasColumn('member_typs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });*/


        // add company_id to menus
        Schema::table('menus', function (Blueprint $table) {
            if (Schema::hasColumn('menus', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('menu_columns', function (Blueprint $table) {
            if (Schema::hasColumn('menu_columns', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('m_stocks_in', function (Blueprint $table) {
            if (Schema::hasColumn('m_stocks_in', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('m_stocks_out', function (Blueprint $table) {
            if (Schema::hasColumn('m_stocks_out', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to notes
        Schema::table('notes', function (Blueprint $table) {
            if (Schema::hasColumn('notes', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('note_details', function (Blueprint $table) {
            if (Schema::hasColumn('note_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to opening inventories
        Schema::table('opening_inventories', function (Blueprint $table) {
            if (Schema::hasColumn('opening_inventories', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to opening stocks
        Schema::table('opening_stocks', function (Blueprint $table) {
            if (Schema::hasColumn('opening_stocks', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to opening stocks
        Schema::table('opening_stocks', function (Blueprint $table) {
            if (Schema::hasColumn('opening_stocks', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('other_builds', function (Blueprint $table) {
            if (Schema::hasColumn('other_builds', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to packages
        Schema::table('packages', function (Blueprint $table) {
            if (Schema::hasColumn('packages', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('package_details', function (Blueprint $table) {
            if (Schema::hasColumn('package_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to payments
        Schema::table('payments', function (Blueprint $table) {
            if (Schema::hasColumn('payments', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to payrolls
        Schema::table('payrolls', function (Blueprint $table) {
            if (Schema::hasColumn('payrolls', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to products
        Schema::table('products', function (Blueprint $table) {
            if (Schema::hasColumn('products', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to projects
        Schema::table('projects', function (Blueprint $table) {
            if (Schema::hasColumn('projects', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to project build items
        Schema::table('project_build_items', function (Blueprint $table) {
            if (Schema::hasColumn('project_build_items', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('project_builds', function (Blueprint $table) {
            if (Schema::hasColumn('project_builds', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('project_details', function (Blueprint $table) {
            if (Schema::hasColumn('project_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('project_expenses', function (Blueprint $table) {
            if (Schema::hasColumn('project_expenses', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('project_expense_details', function (Blueprint $table) {
            if (Schema::hasColumn('project_expense_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('project_finishes', function (Blueprint $table) {
            if (Schema::hasColumn('project_finishes', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('project_items', function (Blueprint $table) {
            if (Schema::hasColumn('project_items', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to project categories
        Schema::table('project_categories', function (Blueprint $table) {
            if (Schema::hasColumn('project_categories', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to project item transactions
        Schema::table('project_item_transactions', function (Blueprint $table) {
            if (Schema::hasColumn('project_item_transactions', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to project progresses
        Schema::table('project_progresses', function (Blueprint $table) {
            if (Schema::hasColumn('project_progresses', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('project_services', function (Blueprint $table) {
            if (Schema::hasColumn('project_services', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('project_stocks', function (Blueprint $table) {
            if (Schema::hasColumn('project_stocks', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('project_stocks', function (Blueprint $table) {
            if (Schema::hasColumn('project_stocks', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('project_stock_outs', function (Blueprint $table) {
            if (Schema::hasColumn('project_stock_outs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('project_transactions', function (Blueprint $table) {
            if (Schema::hasColumn('project_transactions', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('project_wastages', function (Blueprint $table) {
            if (Schema::hasColumn('project_wastages', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to purchases
        Schema::table('purchases', function (Blueprint $table) {
            if (Schema::hasColumn('purchases', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('purchase_discounts', function (Blueprint $table) {
            if (Schema::hasColumn('purchase_discounts', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('purchase_infos', function (Blueprint $table) {
            if (Schema::hasColumn('purchase_infos', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('purchase_orders', function (Blueprint $table) {
            if (Schema::hasColumn('purchase_orders', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('purchase_order_details', function (Blueprint $table) {
            if (Schema::hasColumn('purchase_order_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('purchase_order_records', function (Blueprint $table) {
            if (Schema::hasColumn('purchase_order_records', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to purchase orders
        Schema::table('purchase_orders', function (Blueprint $table) {
            if (Schema::hasColumn('purchase_orders', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('quantities', function (Blueprint $table) {
            if (Schema::hasColumn('quantities', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('receivable_payments', function (Blueprint $table) {
            if (!Schema::hasColumn('receivable_payments', 'company_id')) {
                $table->integer('company_id')->unsigned()->nullable();
            }
        });


        Schema::table('recipe_details', function (Blueprint $table) {
            if (Schema::hasColumn('recipe_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('recipe_operators', function (Blueprint $table) {
            if (Schema::hasColumn('recipe_operators', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to recipes
        Schema::table('recipes', function (Blueprint $table) {
            if (Schema::hasColumn('recipes', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to refunds
        Schema::table('refunds', function (Blueprint $table) {
            if (Schema::hasColumn('refunds', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('refund_stocks', function (Blueprint $table) {
            if (Schema::hasColumn('refund_stocks', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to refund return payments
        Schema::table('refund_return_payments', function (Blueprint $table) {
            if (Schema::hasColumn('refund_return_payments', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('return_refund_details', function (Blueprint $table) {
            if (Schema::hasColumn('return_refund_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to refund return transactions
        Schema::table('refund_return_transactions', function (Blueprint $table) {
            if (Schema::hasColumn('refund_return_transactions', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('return_stock_outs', function (Blueprint $table) {
            if (Schema::hasColumn('return_stock_outs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to refund return transactions
        Schema::table('rents', function (Blueprint $table) {
            if (Schema::hasColumn('rents', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to refund return transactions
        Schema::table('return_backs', function (Blueprint $table) {
            if (Schema::hasColumn('return_backs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to refund return transactions
        Schema::table('salary_details', function (Blueprint $table) {
            if (Schema::hasColumn('salary_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to refund return transactions
        Schema::table('sales', function (Blueprint $table) {
            if (Schema::hasColumn('sales', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to sales orders
        Schema::table('sales_orders', function (Blueprint $table) {
            if (Schema::hasColumn('sales_orders', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('sales_order_details', function (Blueprint $table) {
            if (Schema::hasColumn('sales_order_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('sales_order_records', function (Blueprint $table) {
            if (Schema::hasColumn('sales_order_records', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('sale_infos', function (Blueprint $table) {
            if (Schema::hasColumn('sale_infos', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to sale areas
        Schema::table('sale_areas', function (Blueprint $table) {
            if (Schema::hasColumn('sale_areas', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to sale items
        Schema::table('sale_items', function (Blueprint $table) {
            if (Schema::hasColumn('sale_items', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('sale_order_receives', function (Blueprint $table) {
            if (Schema::hasColumn('sale_order_receives', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('sale_order_services', function (Blueprint $table) {
            if (Schema::hasColumn('sale_order_services', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('sale_receives', function (Blueprint $table) {
            if (Schema::hasColumn('sale_receives', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('sale_services', function (Blueprint $table) {
            if (Schema::hasColumn('sale_services', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('sale_transactions', function (Blueprint $table) {
            if (Schema::hasColumn('sale_transactions', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to sale items
        Schema::table('send_moneys', function (Blueprint $table) {
            if (Schema::hasColumn('send_moneys', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to service classes
        Schema::table('service_classes', function (Blueprint $table) {
            if (Schema::hasColumn('service_classes', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to stocks
        Schema::table('stocks', function (Blueprint $table) {
            if (Schema::hasColumn('stocks', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to stocks
        Schema::table('stock_outs', function (Blueprint $table) {
            if (Schema::hasColumn('stock_outs', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('system_alerts', function (Blueprint $table) {
            if (Schema::hasColumn('system_alerts', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('s_products', function (Blueprint $table) {
            if (Schema::hasColumn('s_products', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        Schema::table('s_products', function (Blueprint $table) {
            if (Schema::hasColumn('s_products', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to temp_items
        Schema::table('temp_items', function (Blueprint $table) {
            if (Schema::hasColumn('temp_items', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to stucks
        Schema::table('transactions', function (Blueprint $table) {
            if (Schema::hasColumn('transactions', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to stucks
        Schema::table('transfers', function (Blueprint $table) {
            if (Schema::hasColumn('transfers', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to stucks
        Schema::table('transfer_accounts', function (Blueprint $table) {
            if (Schema::hasColumn('transfer_accounts', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to stucks
        Schema::table('transfer_and_loadings', function (Blueprint $table) {
            if (Schema::hasColumn('transfer_and_loadings', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to stucks
        Schema::table('transfer_details', function (Blueprint $table) {
            if (Schema::hasColumn('transfer_details', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        Schema::table('transports', function (Blueprint $table) {
            if (Schema::hasColumn('transports', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

        // add company_id to stucks
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });


        // add company_id to work types
        Schema::table('work_types', function (Blueprint $table) {
            if (Schema::hasColumn('work_types', 'company_id')) {
                $table->dropColumn('company_id');
            }
        });

    }
}
