<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSaleByTypeDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('sale_by_type_details')) {
            Schema::create('sale_by_type_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('sale_id')->unsigned();
                $table->string('type');
                $table->integer('type_id')->unsigned();
                $table->integer('driver_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_by_type_details');
    }
}
