<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayrollFormsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('payroll_forms')) {
            Schema::create('payroll_forms', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->double('amount')->defualt(0);
                $table->integer('times',false);
                $table->double('rate')->defualt(0);
                $table->double('hq_rate')->defualt(0)->nullable();
                $table->string('currency')->nullable();
                $table->unsignedInteger('price_detail_id');
                $table->unsignedInteger('expense_id');
                $table->unsignedInteger('payable_id');
                $table->unsignedInteger('payroll_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_forms');
    }
}
