<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateItemNoneCostDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('item_none_cost_details')) {
            Schema::create('item_none_cost_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->timestamps();
                $table->integer('item_none_cost_id')->unsigned();
                $table->integer('asset_transaction')->unsigned();
                $table->integer('cost_transaction')->unsigned();
                $table->integer('site_id')->unsigned();
                $table->integer('um_id')->unsigned();
                $table->integer('inventory_id')->unsigned();
                $table->integer('inventory_category_id')->unsigned();
                $table->double('quantity');
                $table->double('cost');

            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_none_cost_details');
    }
}
