<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateItemNoneCostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('item_none_costs')) {
            Schema::create('item_none_costs', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('ref_no')->nullable();
                $table->integer('account_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->string('description')->nullable();
                $table->datetime('date');

                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_none_costs');
    }
}
