<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayrollPriceLevelDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('payroll_price_level_details')) {
            Schema::create('payroll_price_level_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('measure_unit_id');
                $table->integer('payroll_price_level_id')->unsigned();
                $table->integer('item_type_payroll_id')->unsigned();
                $table->double('amount');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_price_level_details');
    }
}
