<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateItemTypePayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('item_type_payrolls')) {
            Schema::create('item_type_payrolls', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name');
                $table->integer('account_id')->unsigned()->nullable();
                $table->string('type');
                $table->integer('company_id')->unsigned()->nullable();
                $table->string('description')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_type_payrolls');
    }
}
