<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHomeCurrenciesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('home_currencies')) {
            Schema::create('home_currencies', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('company_id', false);
                $table->unsignedInteger('currency_id', false);
                $table->unsignedInteger('user_id', false);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('home_currencies');
    }
}
