<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBankChecksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('bank_checks')) {
            Schema::create('bank_checks', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('check_number');
                $table->datetime('date');
                $table->integer('member_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->string('type');
                $table->integer('type_id')->unsigned();
                $table->string('status')->nullable();
                $table->string('description')->nullable();
                $table->string('category');

                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank_checks');
    }
}
