<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGroupCompanySettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('group_company_settings')){

            Schema::create('group_company_settings', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('count',false);
                $table->text('logo')->nullable();
                $table->text('theme_color');
                $table->text('package_name');
                $table->timestamps();
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('group_company_settings');
    }
}
