<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinedDriversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('fined_drivers'))
        {
            Schema::create('fined_drivers', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('driver_id')->unsigned();
                $table->integer('transfer_and_loading_id')->unsigned();
                $table->integer('inventory_transfer_info_id')->unsigned();
                $table->string('currency')->nullable();
                $table->double('rate')->nullable();
                $table->double('amount')->nullable();
                $table->string('car_type')->nullable();
                $table->string('plate_number')->nullable();
                $table->integer('transaction_id')->unsigned()->nullable();
                $table->integer('other_income_transaction_id')->unsigned()->nullable();
            

                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fined_drivers');
    }
}
