<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransferAndLoadingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('transfer_and_loadings'))
        {
        Schema::create('transfer_and_loadings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('type');
            $table->integer('type_id')->unsigned();
            $table->integer('inventory_transfer_id')->unsigned();
            $table->integer('adjustment_id')->unsigned()->nullable();
            $table->integer('other_income_account_id')->unsigned()->nullable();
            $table->datetime('date');
            $table->string('description')->nullable();
			$table->string('ref_no')->nullable();
            $table->timestamps();
        });
    }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transfer_and_loadings');
    }
}
