<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGiftsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('gifts'))
        {
        Schema::create('gifts', function (Blueprint $table) {
            $table->bigIncrements('id');
			
            $table->integer('customer_id')->unsigned();
			$table->integer('inventory_category_id')->unsigned();
            $table->integer('categ_um_id')->unsigned();
            $table->double('qty', 10)->nullable();
            $table->string('customer_type')->nullable();
			$table->integer('item_id')->unsigned();
            $table->integer('gift_um_id')->unsigned();
            $table->double('gift_qty', 10)->nullable();
            $table->datetime('start_date')->nullable();
            $table->datetime('end_date')->nullable();
            $table->string('mounth')->nullable();
            $table->string('status')->nullable();
            $table->string('description')->nullable();
            $table->integer('sale_id')->unsigned();
            $table->integer('user_id')->unsigned();
			
            $table->timestamps();
        });
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gifts');
    }
}
