<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInventoryReceivesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('inventory_receives'))
        {
            Schema::create('inventory_receives', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('purchase_id')->unsigned()->nullable();
                $table->integer('sale_id')->unsigned()->nullable();
                $table->string('transfer_code')->nullable();
                $table->string('transporter_name')->nullable();
                $table->string('transporter_phone')->nullable();
                $table->string('palce_of_weight')->nullable();
                $table->string('source_place')->nullable();
                $table->string('plate_number')->nullable();
                $table->string('way_bill_number')->nullable();
                $table->string('total_weight')->nullable();
                $table->string('empty_car_weight')->nullable();
                $table->string('total_bori')->nullable();
                $table->text('transfer_description')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventory_receives');
    }
}
