<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContractDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('contract_details'))
        {
            Schema::create('contract_details', function (Blueprint $table) {
                $table->bigIncrements('id');
        
                $table->integer('contract_id')->unsigned();
                $table->integer('inventory_id')->unsigned();
                $table->integer('um_id')->unsigned();
                $table->integer('site_id')->unsigned()->nullable();
                $table->integer('inventory_category_id')->unsigned()->nullable();
                $table->double('cost');
                $table->double('qty');
                $table->double('discount')->nullable();
                $table->string('description')->nullable();
                $table->datetime('expire_date')->nullable();
                
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contract_details');
    }
}
