<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInformationToUpdatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('information_to_updates'))
        {
            Schema::create('information_to_updates', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('type_id')->unsigned();
                $table->datetime('date');
                $table->string('type');
                $table->integer('priority')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('information_to_updates');
    }
}
