<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTempItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('temp_items'))
        {
            Schema::create('temp_items', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name');
                $table->string('code')->nullable();
                $table->string('serial_number')->nullable();
                $table->string('description')->nullable();
                $table->string('category')->nullable();
                
                $table->double('quantity')->nullable();
                $table->double('purchase_rate')->nullable();
                $table->double('sale_rate')->nullable();
                $table->double('min')->nullable();
                $table->double('max')->nullable();
                $table->integer('um_id')->unsigned()->nullable();
                $table->integer('inventory_category_id')->unsigned()->nullable();
                $table->date('date')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('temp_items');
    }
}
