<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTransactionIdToReturnBacksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('return_backs', function (Blueprint $table) {
            if(!Schema::hasColumn('return_backs','transaction_id') && !Schema::hasColumn('return_backs','discount_transaction'))
            {
                $table->integer('transaction_id')->unsigned();
				$table->integer('discount_transaction')->unsigned()->nullable();
				$table->string('discount_type')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('return_backs', function (Blueprint $table) {
            //
        });
    }
}
