<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCurrencyToMemberTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('member_transfers', function (Blueprint $table) {
             if(!Schema::hasColumn('member_transfers','currency'))
             {
                $table->string('currency');
                $table->double('rate');
                $table->double('payable')->nullable();
                $table->double('receivable')->nullable();
             }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('member_transfers', function (Blueprint $table) {
            //
        });
    }
}
