<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSystemAlertsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('system_alerts'))
        {
            Schema::create('system_alerts', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->datetime('date')->nullable();
                $table->integer('member_id')->unsigned()->nullable();
                $table->integer('receive_id')->unsigned()->nullable();
                $table->integer('payment_id')->unsigned()->nullable();
                $table->integer('sale_id')->unsigned()->nullable();
                $table->text('description')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('system_alerts');
    }
}
