<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInventoryTransferInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('inventory_transfer_infos'))
        {
            Schema::create('inventory_transfer_infos', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('inventory_category_id')->unsigned()->nullable();
                $table->integer('inventory_id')->unsigned();
                $table->integer('from_site_id')->unsigned();
                $table->integer('to_site_id')->unsigned();
                $table->integer('um_id')->unsigned();
                $table->integer('inventory_transfer_id')->unsigned();
                $table->double('qty');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventory_transfer_infos');
    }
}
