<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContractPurchasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('contract_purchases'))
        {
            Schema::create('contract_purchases', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('contract_id')->unsigned();
                $table->integer('purchase_id')->unsigned();
                $table->string('wagon_number')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contract_purchases');
    }
}
