<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDeliveryDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('delivery_details'))
        {
            Schema::create('delivery_details', function (Blueprint $table) {
                $table->bigIncrements('id');
    			$table->integer('delivery_id')->unsigned()->nullable();
    			$table->integer('inventory_id')->unsigned()->nullable();
    			$table->integer('project_item_id')->unsigned()->nullable();
                $table->integer('site_id')->unsigned()->nullable();
                $table->integer('um_id')->unsigned()->nullable();
                $table->integer('asset_transaction')->unsigned()->nullable();
                $table->integer('cost_transaction')->unsigned()->nullable();
                $table->integer('stock_out_id')->unsigned()->nullable();
                $table->double('cost');
                $table->double('qty');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('delivery_details');
    }
}
