<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDeliveryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('deliveries'))
        {
            Schema::create('deliveries', function (Blueprint $table) {
                $table->bigIncrements('id');
    			$table->integer('number')->unsigned();
                $table->datetime('date')->nullable();
                $table->string('type')->nullable();
                $table->string('description')->nullable();
                $table->integer('member_id')->unsigned();
                $table->integer('project_id')->unsigned();
                $table->integer('user_id')->unsigned();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deliveries');
    }
}
