<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMStocksOutTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('m_stocks_out'))
        {
            Schema::create('m_stocks_out', function (Blueprint $table) {
                $table->bigIncrements('id');
    			
    			$table->integer('stock_id')->unsigned();
                $table->integer('main_stock_id')->unsigned();
                $table->integer('inventory_id')->unsigned();
                $table->integer('sale_id')->unsigned();
                $table->integer('sale_um_id')->unsigned();
                $table->integer('customer_id')->unsigned();
                $table->integer('user_id')->unsigned();
                $table->integer('build_id')->unsigned();
                $table->datetime('date_out')->nullable();
                $table->double('qut_out', 16)->nullable();
                $table->double('sales_price', 16)->nullable();
                $table->integer('status')->default(0);
    			
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m_stocks_out');
    }
}
