<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMStocksInTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('m_stocks_in'))
        {
            Schema::create('m_stocks_in', function (Blueprint $table) {
                $table->bigIncrements('id');
    			
    			$table->string('code');
                $table->integer('main_stock_id');
                $table->double('widths')->nullable();
                $table->double('lengths')->unsigned();
                $table->datetime('date_in')->nullable();
                $table->double('prime_cost', 16)->nullable();
                $table->double('qut_in', 16)->nullable();
                $table->double('cost', 16)->nullable();
                $table->integer('status')->default(0);
                $table->datetime('expire_date')->nullable();
                $table->double('other_measure')->nullable();
                
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m_stocks_in');
    }
}
