<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMainStocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('main_stocks'))
        {
            Schema::create('main_stocks', function (Blueprint $table) {
                $table->bigIncrements('id');
    			
    			$table->integer('inventory_id')->unsigned();
                $table->integer('user_id')->unsigned();
                $table->integer('inventory_site_id')->unsigned()->nullable();
                $table->integer('purchase_id')->unsigned();
                $table->integer('vendor_id')->unsigned();
                $table->datetime('date_in')->nullable();
                $table->double('qut_in', 16)->nullable();
                $table->double('cost', 16)->nullable();
                $table->string('description')->nullable();
                $table->integer('status')->default(0);
                $table->datetime('expire_date')->nullable();
                $table->integer('purchase_um_id')->unsigned();
    			$table->double('other_measure')->nullable();
                $table->double('expense_cost')->nullable();
    			
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('main_stocks');
    }
}
