<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAttachmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('attachments'))
        {
            Schema::create('attachments', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('title');
                $table->text('description')->nullable();
                $table->string('path')->nullable();
                $table->string('table_name');
                $table->integer('foreign_data_id')->unsigned();
                $table->string('u_file');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('attachments');
    }
}
