<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSystemConfigsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('system_configs'))
        {
            Schema::create('system_configs', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('tag');
                $table->boolean('taken')->nullable();
                $table->integer('user_count');
                $table->integer('inventory_site_count');
                $table->boolean('custom_report')->nullable();
                $table->boolean('build')->nullable();
                $table->boolean('prophil')->nullable();
                $table->boolean('pvc')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('system_configs');
    }
}
