<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFactorDesignsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('factor_designs'))
        {
            Schema::create('factor_designs', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('header')->nullable();
                $table->string('footer')->nullable();
                $table->string('watermark')->nullable();
                $table->double('watermark_opacity')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('factor_designs');
    }
}
