<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBuildExpensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('build_expenses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('build_id');
            $table->integer('assembly_expense_id')->nullable();
            $table->integer('account_id')->nullable();
            $table->string('description')->nullable();
            $table->string('expense_transaction')->nullable();
            $table->double('amount')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('build_expenses');
    }
}
