<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBuildInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('build_infos', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('recipe_id')->unsigned();
            $table->integer('build_id')->unsigned();
            $table->string('shift');
            $table->string('device_wash');
            $table->time('start_hour');
            $table->time('end_hour');
            $table->integer('stoped_hours');
            $table->string('qty_and_caus_of_stop');
            $table->integer('device_speed');
            $table->integer('start_meter');
            $table->integer('end_meter');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('build_infos');
    }
}
