<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRefundReturnTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('refund_return_transactions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('type');
            $table->integer('type_id')->unsigned();
            $table->integer('inventory_id')->unsigned();
            $table->integer('income_transaction')->unsigned();
            $table->integer('cost_transaction')->unsigned();
            $table->integer('asset_transaction')->unsigned();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('refund_return_transactions');
    }
}
