<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTransactionIdToRefundsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('refunds', function (Blueprint $table) {
             if(!Schema::hasColumn('refunds','transaction_id') && !Schema::hasColumn('refunds','discount_transaction'))
             {
                $table->integer('transaction_id')->unsigned();
            $table->integer('discount_transaction')->unsigned()->nullable();
            $table->string('discount_type')->nullable();
             }
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('refunds', function (Blueprint $table) {
            //
        });
    }
}
