<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateItemExpenseDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
 
        Schema::create('item_expense_details', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('item_expense_id')->unsigned();
            $table->integer('stock_id')->unsigned();
            $table->integer('transaction_id')->unsigned();
            $table->string('category');
            $table->double('materialCost')->nullable();
            $table->double('transportCost')->nullable();
            $table->double('customeCost')->nullable();
            $table->double('laborCost')->nullable();
            $table->double('subContractorCost')->nullable();
            $table->double('manufacturingCost')->nullable();
            $table->double('otherCost')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_expense_details');
    }
}
