<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transfers', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('transport_id')->unsigned()->nullable();
            $table->string('transporter_name')->nullable();
            $table->string('transporter_fname')->nullable();
			 $table->string('transporter_phone')->nullable();
            $table->string('number')->nullable();
            $table->datetime('date')->nullable();
            $table->datetime('departure_date')->nullable();
            $table->string('type')->nullable();
            $table->integer('type_id')->unsigned()->nullable();
            $table->boolean('status');
            $table->text('description')->nullable();
            $table->string('receiver')->nullable();
            $table->string('plate_number')->nullable();
            $table->string('commitment')->nullable();
            $table->string('destination')->nullable();
            $table->string('car_type')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transfers');
    }
}
